import { View, Text, FlatList, TouchableWithoutFeedback } from "react-native";
import React, { useEffect } from "react";
import { relatedItemStyle } from "./relatedItemStyle";
import ProgressiveImage from "../../../../../src/components/ProgressiveImage";
import { ProductsStyle } from "../../featureProductsStyle";
import { useNavigation } from "@react-navigation/native";
import FeatureCategorySkeleton from "../../../../../src/skeletons/screens/home/FeatureCategorySkeleton";
import { BASE_API_URL_STG } from "@env";
import { useState } from "react";
import { queryResponse } from "../../../../../redux/slices/util/processResponse";
import { PRODUCT_DETAILS } from "../../../../../components/Navigation/RouteNames";

const RelatedItem = ({ headerText, related_ids }) => {

    const [relatedProducts, setRelatedProducts] = useState([]);
    const [loading, setLoading] = useState(false);

    useEffect(() => {
        (async() => {
            if (related_ids?.length > 0) {
                let relatedAllIds = "?product_ids=";

                related_ids.forEach((id) => {
                    relatedAllIds = relatedAllIds + `${id},`;
                });
                let URL = `${BASE_API_URL_STG}/user/products${relatedAllIds.slice(0, -1)}`;
                setLoading(true);
                try{
                    const res = await queryResponse(URL);
                    const {records, status} = res;
                    if (status?.code == 200) {
                        setRelatedProducts(records?.data);
                        setLoading(false);
                    }
                } catch(e) {}
            }
        })()
    }, [related_ids]);

    return (
        <View style={relatedItemStyle.container}>
            {loading ? (
                <View>
                    <FlatList
                        keyExtractor={(_, i) => "rp" + i}
                        data={[1, 2, 3, 4]}
                        horizontal={true}
                        renderItem={({ item }) => (
                            <FeatureCategorySkeleton item={item} />
                        )}
                        showsHorizontalScrollIndicator={false}
                    />
                </View>
            ) : (
                <View>
                    <Text style={relatedItemStyle.title}>{headerText}</Text>
                    <FlatList
                        data={relatedProducts}
                        renderItem={({ item }) => <RenderItem item={item} />}
                        keyExtractor={(_, i) => "key" + i}
                        horizontal
                        showsHorizontalScrollIndicator={false}
                    />
                </View>
            )}
        </View>
    );
};

export default RelatedItem;

const RenderItem = ({ item }) => {
    const navigation = useNavigation();
    const productsStyle = ProductsStyle();
    return (
        <TouchableWithoutFeedback
            onPress={() => {
                navigation.push(PRODUCT_DETAILS, {
                    slug: item?.slug,
                    item
                });
            }}
        >
            <View style={productsStyle.imgCont}>
                <ProgressiveImage
                    source={{ uri: item?.featured_image }}
                    style={productsStyle.img}
                />
            </View>
        </TouchableWithoutFeedback>
    );
};
